<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'ajax');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array ('posting','umg');
switch ($_POST['do'])
{
	case 'fetchuserfield':
	case 'saveuserfield':
		$phrasegroups[] = 'cprofilefield';
		$phrasegroups[] = 'user';
		break;
	case 'mediarate':
		$phrasegroups[] = 'showthread';
		break;
}

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array(
	'fetchtitlefield' => array (
		'umg_media_title_editor',

		'memberinfo_customfield_edit',
		'userfield_checkbox_option',
		'userfield_optional_input',
		'userfield_radio',
		'userfield_radio_option',
		'userfield_select',
		'userfield_select_option',
		'userfield_select_multiple',
		'userfield_textarea',
		'userfield_textbox',
	)
);

$_POST['ajax'] = 1;

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_xml.php');
require_once(DIR . '/umg_gallery/umg_functions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if ($_POST['do'] == 'tagsearch')
{

	$vbulletin->input->clean_array_gpc('p', array('fragment' => TYPE_STR));

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 3)
	{
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else
	{
		$fragment = '';
	}

	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_group ('tags');

	if ($fragment != '')
	{
		$tags = $db->query_read_slave ("
			SELECT tagtext
			FROM " . TABLE_PREFIX . "umg_tag
			WHERE tagtext LIKE '" . $db->escape_string_like ($fragment) . "%'
			ORDER BY tagtext
			LIMIT 15
		");
		while ($tag = $db->fetch_array ($tags))
		{
			$xml->add_tag ('tag', $tag['tagtext']);
		}
	}

	$xml->close_group ();
	$xml->print_xml ();

}
else if ($_POST['do'] == 'click')
{

	$vbulletin->input->clean_array_gpc ('p', array(
		'm'    => TYPE_INT
	));
	if (!$vbulletin->GPC['m'])
	{
		echo $vbphrase['umg_error_no_media'];
	}
	else
	{
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_media SET counter=counter+1 WHERE mediaid=" . $vbulletin->GPC['m']);

		$media = $db->query_first ("SELECT 
			media.counter,cat.userid AS gallery
			FROM " . TABLE_PREFIX . "umg_media AS media 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS cat ON (cat.catid=media.catid) 
			WHERE media.mediaid=" . $vbulletin->GPC['m'] . "
			GROUP BY media.mediaid
		");
		umg_create_datastore ('counter_' . (!$media['gallery'] ? 'public' : 'private'));

		echo '<span class="smallfont" id="mediahits">' . $media['counter'];
	}
	exit();
}
else if ($_POST['do'] == 'mediarate')
{
	$vbulletin->input->clean_array_gpc ('p', array(
		'vote' => TYPE_UINT,
		'm'    => TYPE_INT
	));

	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_group ('mediarating');

	$update = 0;
	if ($vbulletin->userinfo['userid'])
	{
		if ($rating = $db->query_first ("
			SELECT *
			FROM " . TABLE_PREFIX . "umg_rating 
			WHERE userid=" . $vbulletin->userinfo['userid'] . " 
			AND mediaid=" .  $vbulletin->GPC['m']
		))
		{
			if (!$vbulletin->GPC['ajax']) eval (standard_error ($vbphrase['umg_error_you_voted']));
			else $xml->add_tag ('error', $vbphrase['umg_error_you_voted']);
		}
		else
		{
			$cat = $db->query_first ("
				SELECT c.rateit 
				FROM " . TABLE_PREFIX . "umg_media as m
				LEFT JOIN " . TABLE_PREFIX . "umg_category AS c ON (c.catid=m.catid) 
				WHERE m.mediaid=" .  $vbulletin->GPC['m']
			);
			if ($cat['rateit'])
			{
				// save vote
				$db->query_write ("
					INSERT INTO " . TABLE_PREFIX . "umg_rating 
					(`mediaid`,`userid`,`vote`) 
					VALUES 
					(" . $vbulletin->GPC['m'] . "," . $vbulletin->userinfo['userid'] . "," . $vbulletin->GPC['vote'] . ")
				");
				$db->query_write ("
					UPDATE " . TABLE_PREFIX . "umg_media SET 
					`votenum`=`votenum`+'1',
					`votetotal`=`votetotal`+" . $vbulletin->GPC['vote'] . " 
					WHERE mediaid=" . $vbulletin->GPC['m']
				);

				$update = 1;
				if (!$vbulletin->GPC['ajax'])
				{
					$vbulletin->url = 'umg.php?' . $vbulletin->session->vars['sessionurl'] . "m=" . $vbulletin->GPC['m'];
					eval (print_standard_redirect ('redirect_threadrate_add'));
				}
			}
			else
			{
				$update = 2;
				$xml->add_tag ('error', $vbphrase['umg_error_cant_rate']);
			}
		}
	}
	else
	{
		$xml->add_tag ('error', $vbphrase['umg_error_no_rate_permission']);
	}

	if ($update == 1)
	{
		$media = $db->query_first_slave ("
			SELECT votetotal, votenum
			FROM " . TABLE_PREFIX . "umg_media
			WHERE mediaid=" . $vbulletin->GPC['m']
		);

		if ($media['votenum'] >= $vbulletin->options['showvotes'])
		{
			$media['voteavg'] = vb_number_format ($media['votetotal'] / $media['votenum'], 2);
			$media['rating'] = round ($media['votetotal'] / $media['votenum']);
			$xml->add_tag ('voteavg', process_replacement_vars ("$vbphrase[rating]: <img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$media[rating].gif\" alt=\"" . construct_phrase($vbphrase['umg_rating_x_votes_y_average'], $media['votenum'], $media['voteavg']) . "\" border=\"0\" />"));
			$xml->add_tag ('mediavg', process_replacement_vars ("<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$media[rating].gif\" alt=\"" . construct_phrase($vbphrase['umg_rating_x_votes_y_average'], $media['votenum'], $media['voteavg']) . "\" border=\"0\" />"));
		}
		else
		{
			$xml->add_tag ('voteavg', '');
		}

		if (!function_exists ('fetch_phrase')) require_once(DIR . '/includes/functions_misc.php');
		$xml->add_tag ('message', $vbphrase['umg_error_vote_added']);
	}
	else if (!$update)
	{
		$xml->add_tag ('error', $vbphrase['umg_error_already_voted']);
	}

	$xml->close_group ();
	$xml->print_xml ();
	exit ();
}

if ($_POST['do'] == 'fetchtitlefield')
{
	$vbulletin->input->clean_array_gpc ('p', array(
		'fieldid' => TYPE_UINT
	));

	if (!$vbulletin->userinfo['userid']) print_no_permission ();

	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_group ('response');

	if ($media = $db->query_first ("SELECT mediaid,title FROM " . TABLE_PREFIX . "umg_media WHERE mediaid=" . $vbulletin->GPC['fieldid']))
	{
		eval ('$media_template = "' . fetch_template ('umg_media_title_editor') . '";');
		$xml->add_tag ('template', $media_template);
	}
	else
	{
		print_no_permission ();
	}

	$xml->close_group ();
	$xml->print_xml ();
	exit ();
}

if ($_POST['do'] == 'savetitlefield')
{
	$vbulletin->input->clean_array_gpc ('p', array(
		'fieldid'    => TYPE_UINT,
		'titlefield' => TYPE_NOHTML
	));

	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->GPC['fieldid']) print_no_permission();

	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_group ('response');

	if ($vbulletin->GPC['fieldid'])
	{
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_media SET title='" . $db->escape_string (addslashes ($vbulletin->GPC['titlefield'])) . "' WHERE mediaid=" . $vbulletin->GPC['fieldid']);
		$xml->add_tag('value', $vbulletin->GPC['titlefield']);
	}
	else $xml->add_tag ('value', 'uneditable');

	$xml->close_group ();
	$xml->print_xml ();
	exit();
}

if ($_POST['do'] == 'updatecategorytitle')
{
	$vbulletin->input->clean_array_gpc ('p', array(
		'categoryid' => TYPE_UINT,
		'title'      => TYPE_STR
	));

	$categorytitle = convert_urlencoded_unicode ($vbulletin->GPC['title']);
	$category = $db->query_first ("SELECT userid,title FROM " . TABLE_PREFIX ."umg_category WHERE catid=" . $vbulletin->GPC['categoryid']);

	if (
		($category['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR 
		($vbulletin->userinfo['umgid'] == 3 AND $vbulletin->userinfo['userid']) OR 
		($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
	)
	{
		$db->query_write ("UPDATE " . TABLE_PREFIX ."umg_category SET 
			title='" . $db->escape_string ($categorytitle) . "' 
			WHERE catid=" . $vbulletin->GPC['categoryid']
		);
	}
	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_tag ('linkhtml', $categorytitle);
	$xml->print_xml ();
	exit();
}

// ###########################################################################
// New Securitytoken
if ($_POST['do'] == 'securitytoken')
{
	$xml = new vB_AJAX_XML_Builder ($vbulletin, 'text/xml');
	$xml->add_tag ('securitytoken', $vbulletin->userinfo['securitytoken']);
	$xml->print_xml ();
}
?>
